
import os
import random
import subprocess

def main():
    # Make sure the instances folder exists
    if not os.path.exists("instances"):
        os.makedirs("instances")
    
    # Generate 50 instances
    for i in range(1, 51):
        # Randomly pick parameters
        num_rows = random.choice([1, 2, 3])
        num_columns = random.choice([3, 4, 5])
        num_robots = random.choice([1, 2])
        
        if num_rows == 3 and num_columns == 5:
            num_rows = 2
        
        if num_rows == 1 and num_columns == 3:
            num_rows = 2
            
        if num_rows * num_columns < 12:
            num_robots = 1
        
        # mode_flag can be "seq" or "time". If you want them all to be "seq", fix it.
        mode_flag = "seq"
        
        # Use a random seed to ensure uniqueness
        seed = random.randint(1, 999999)
        
        # Name of the problem instance (without extension)
        instance_name = f"instance-{i}"
        
        # Command to run your original generator script
        # (Assuming your original script is called floor_tile_generator.py
        #  and is in the same folder.)
        cmd = [
            "python",
            "floortile-generator.py",
            instance_name,
            str(num_rows),
            str(num_columns),
            str(num_robots),
            mode_flag,
            str(seed)
        ]
        
        # Output file path
        outfile = os.path.join("instances", f"{instance_name}.pddl")
        
        print(f"Generating {outfile} with rows={num_rows}, cols={num_columns}, robots={num_robots}, mode={mode_flag}, seed={seed}")
        
        # Run the command and redirect stdout to the instance file
        with open(outfile, "w") as f:
            subprocess.run(cmd, stdout=f, check=True)

if __name__ == "__main__":
    main()